﻿
IF EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[UserRespondent]'))
BEGIN
	DROP TABLE [UserRespondent]
END
GO	
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[Respondent]') AND name = 'Location')
BEGIN
	ALTER TABLE [Respondent] ADD [Location] tinyint NOT NULL DEFAULT(0)		
END
GO	
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UserQuota]') AND type in (N'U'))
BEGIN
	CREATE TABLE [UserQuota]
	(		
		[QuotaId] INT NOT NULL,
		[UserId] INT NOT NULL,
		[Quota] FLOAT NULL,
		[Frequence] FLOAT NULL,
		[Status] INT NULL,
		[ToDo] AS CASE WHEN [Quota] - ISNULL([Frequence], 0) >= 0 THEN [Quota] - ISNULL([Frequence], 0) ELSE 0 END,
		[CreatedBy] INT NULL,
		[CreationDate] DATETIME NULL,		
		[ModifiedBy] INT NULL ,
		[ModificationDate] DATETIME NULL,
		CONSTRAINT [PK_UserQuota] PRIMARY KEY CLUSTERED ([QuotaId], [UserId] ASC),
		CONSTRAINT [FK_UserQuota_Quota] FOREIGN KEY([QuotaId]) REFERENCES [Quota] ([QtQuotaId]) ON DELETE CASCADE		
	)
END
GO

IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[Respondent]') AND name = 'AppointmentDate')
BEGIN
	ALTER TABLE [Respondent] ADD AppointmentDate datetime NULL
END
GO	
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[Historic]') AND name = 'UserName')
BEGIN
	ALTER TABLE [Historic] ADD [UserName] nvarchar(256) NULL
END
GO	
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[RespondentActivitySummary]') AND name = 'CompletedOn')
BEGIN
	ALTER TABLE [RespondentActivitySummary] ADD [CompletedOn] datetime NULL	
END
GO
IF NOT EXISTS (SELECT * FROM sys.all_columns WHERE [object_id] = OBJECT_ID('[Respondent]') AND name = 'OfflineUserId')
BEGIN
	ALTER TABLE [Respondent] ADD [OfflineUserId] int NULL	
END
GO	

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_GetRespondentUsers]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE [VX_sp_GetRespondentUsers]
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_GetRespondentUser]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE [VX_sp_GetRespondentUser]
GO
CREATE PROCEDURE [VX_sp_GetRespondentUser]
(
	@respondentId int
)
AS
BEGIN
	SELECT [OfflineUserId], [UserName] FROM [Respondent]
	INNER JOIN [Users] ON [Id] = [OfflineUserId]
	WHERE [ResRespondent] = @respondentId
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_ClearRespondentUsers]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE [VX_sp_ClearRespondentUsers]
GO
CREATE PROCEDURE [VX_sp_ClearRespondentUsers]
(
	@respondentId int
)
AS
BEGIN
	UPDATE [Respondent] SET [OfflineUserId] = NULL, [Modified] = GETUTCDATE() WHERE OfflineUserId = @respondentId
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_AddUserRespondent]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE [VX_sp_AddUserRespondent]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_UpdateUserRespondent]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE [VX_sp_UpdateUserRespondent]
GO
CREATE PROCEDURE [VX_sp_UpdateUserRespondent]
(
	@userId int,
	@respondentId int
)
AS
BEGIN
	UPDATE [Respondent] SET [OfflineUserId] = @userId, [Modified] = GETUTCDATE() WHERE [ResRespondent] = @respondentId
END
GO

IF NOT EXISTS (select * from sys.all_columns where [object_id] = object_id('CaseAssignmentRules'))
BEGIN
	CREATE TABLE [CaseAssignmentRules]
	(		
		[Id]     int IDENTITY NOT NULL,
		[Name] nvarchar(256) NOT NULL,
		[Rule] nvarchar(max) NOT NULL,
		[Active] bit NOT NULL,
		[Status] tinyint NOT NULL,
		[OfflineUserId] int NULL,
		[Priority] int NOT NULL,
		[SQLStatement] nvarchar(max) NOT NULL,
		[CreatedBy] [int] NULL,
		[CreationDate] [datetime] NULL,
		[ModifiedBy] [int] NULL,
		[ModificationDate] [datetime] NULL,
		CONSTRAINT [PK_CaseAssignmentRules] PRIMARY KEY CLUSTERED (Id) 		
	)
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Offline_AudioRecordingFile]') AND type in (N'U'))
BEGIN
	CREATE TABLE [Offline_AudioRecordingFile](
		[FileId] int IDENTITY(1,1) NOT NULL,
		[RespondentId] int NOT NULL,
		[VariableName] nvarchar(255) NOT NULL,
		[InterviewerId] int NOT NULL,
		[FileSize] float NULL,
		[AudioLength] int NULL,
		[CreationDate] datetime NULL,
		CONSTRAINT [PK_Offline_AudioRecordingFile] PRIMARY KEY CLUSTERED( [FileId] ASC, [RespondentId] ASC ),
		CONSTRAINT [FK_Offline_AudioRecordingFile_Respondent] FOREIGN KEY ([RespondentId]) REFERENCES [Respondent] ([ResRespondent]) ON DELETE CASCADE
	)
END
GO



IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'A4S_sp_CreateOfflineAudioRecordingFile') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE A4S_sp_CreateOfflineAudioRecordingFile
GO
CREATE PROCEDURE [A4S_sp_CreateOfflineAudioRecordingFile]
(
	@respondentId int,
	@variableName nvarchar(255),
	@interviewerId int,
	@fileSize float,
	@audioLength int
)
AS
BEGIN
	INSERT INTO [Offline_AudioRecordingFile] ([RespondentId], [VariableName], [InterviewerId], [FileSize], [AudioLength], [CreationDate])
	VALUES ( @respondentId, @variableName, @interviewerId, @fileSize, @audioLength, GETUTCDATE() )
	SELECT @@IDENTITY
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateStrataCounters]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE [VSE_sp_UpdateStrataCounters]
GO
CREATE PROCEDURE [VSE_sp_UpdateStrataCounters]
 @RespondentId INT,
 @Increment  VARCHAR(4000) = '',
 @Decrement  VARCHAR(4000) = '',
 @UpdateOnline BIT = 1
AS
 BEGIN
  DECLARE @Completed AS INT
  DECLARE @OfflineUserId AS INT
  DECLARE @stmt AS VARCHAR(4000)

  SELECT @Completed = [ResCompleted], @OfflineUserId = [OfflineUserId]
  FROM [Respondent]
  WHERE [ResRespondent] = @RespondentId

  IF @Decrement <> '' BEGIN
   SET @stmt = 'UPDATE [Quota] SET [QtSample] = [QtSample] - 1, [QtActive] = [QtActive] - 1, [QtUsed] = [QtUsed] - 1'
   IF @Completed = 1 SET @stmt = @stmt + ', [QtFrequence] = [QtFrequence] - 1'
   IF @UpdateOnline = 1 SET @stmt = @stmt + ', [QtOnline] = CASE WHEN [QtOnline] > 0 THEN [QtOnline] - 1 ELSE 0 END'
   SET @stmt = @stmt + ' WHERE [QtQuotaId] IN (' + @Decrement + ')'
   EXEC(@stmt)

   IF @OfflineUserId IS NOT NULL AND @Completed = 1 BEGIN
    EXEC('UPDATE [UserQuota] SET [Frequence] = [Frequence] - 1 WHERE [UserId] = ' + @OfflineUserId + ' AND [QuotaId] IN (' + @Decrement + ')')
   END
  END

  IF @Increment <> '' BEGIN
   SET @stmt = 'UPDATE [Quota] SET [QtSample] = [QtSample] + 1, [QtActive] = [QtActive] + 1, [QtUsed] = [QtUsed] + 1'
   IF @Completed = 1 SET @stmt = @stmt + ', [QtFrequence] = [QtFrequence] + 1'
   IF @UpdateOnline = 1 SET @stmt = @stmt + ', [QtOnline] = [QtOnline] + 1'
   SET @stmt = @stmt + ' WHERE [QtQuotaId] IN (' + @Increment + ')'
   EXEC(@stmt)

   EXEC('UPDATE [Quota] SET [QtStatus] = 2 WHERE [QtStatus] <> 2 AND [QtQuota] > 0 AND [QtFrequence] >= [QtQuota] AND [QtQuotaId] IN (' + @Increment + ')')

   IF @OfflineUserId IS NOT NULL AND @Completed = 1  BEGIN
    EXEC('UPDATE [UserQuota] SET [Frequence] = [Frequence] + 1, [Status] = CASE WHEN [Frequence] +1 >= [Quota] AND [Quota] > 0 THEN 2 ELSE [Status] END WHERE [UserId] = ' + @OfflineUserId + ' AND [QuotaId] IN (' + @Increment + ')')
   END
  END
 END
GO

---------------------------------
-- VSE_sp_CalculateQuotas
---------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_CalculateQuotas]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE [VSE_sp_CalculateQuotas]
GO
CREATE PROCEDURE [VSE_sp_CalculateQuotas]
	@RespondentId	INT,
	@Strata VARCHAR(4000) = ''
AS
	BEGIN
		DECLARE @OfflineUserId AS INT
		DECLARE @bApplyQuotaRules BIT

		SELECT @OfflineUserId = [OfflineUserId]
		FROM [Respondent]
		WHERE [ResRespondent] = @RespondentId

		SELECT TOP 1 @bApplyQuotaRules = ISNULL(convert(bit,insvalue), 0) FROM Installation WHERE  inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS'
		IF @bApplyQuotaRules IS NULL SET @bApplyQuotaRules = 0

		IF @Strata <> ''
		BEGIN
			EXEC('UPDATE [Quota] SET [QtFrequence] = [QtFrequence] + 1, [QtOnline] = CASE WHEN [QtOnline] > 0 THEN [QtOnline] - 1 ELSE 0 END WHERE [QtQuotaId] IN (' + @Strata + ')')

			IF @OfflineUserId IS NOT NULL 
			BEGIN
				EXEC('UPDATE [UserQuota] SET [QtFrequence] = [QtFrequence] + 1 WHERE [UserId] = ' + @OfflineUserId + ' AND [QuotaId] IN (' + @Strata + ')')
			END

			IF @bApplyQuotaRules = 1
			BEGIN			
				EXEC('UPDATE [Quota] SET [QtStatus] = 2 WHERE [QtStatus] <> 2 AND [QtQuota] > 0 AND [QtFrequence] >= [QtQuota] AND [QtQuotaId] IN (' + @Strata + ')')

				IF @OfflineUserId IS NOT NULL 
				BEGIN
					EXEC('UPDATE [UserQuota] SET [Status] = 2 WHERE [Status] <> 2 AND [Quota] > 0 AND [Frequence] >= [Quota] AND [UserId] = ' + @OfflineUserId + ' AND [QuotaId] IN (' + @Strata + ')')
			END
		END
		END

		--Updating Global Quotas
		UPDATE [Quota] SET [QtFrequence] = [QtFrequence] + 1 WHERE [QtStratum] = 0
	END
GO


---------------------------------
-- VX_sp_RecalculateStratum
---------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VX_sp_RecalculateStratum]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE [VX_sp_RecalculateStratum]
GO
CREATE PROCEDURE [VX_sp_RecalculateStratum]
	@QuotaId INT,
	@ParserQuery NVARCHAR(MAX) = ''
AS
	BEGIN
		IF @ParserQuery = '' 
		BEGIN
			SELECT @parserQuery = [QtParserQuery] FROM [Quota] WHERE [QtQuotaId] = @QuotaId
		END

		IF @ParserQuery <> '' 
		BEGIN
			CREATE TABLE #TempQuotas (OfflineUserId int, [Sample] int, [Active] int, [Completed] int, [Used] int)

			--Old ParserQuery support
			IF CHARINDEX('SELECT @sample=', @ParserQuery) = 1 BEGIN
				DECLARE @sample AS INT
				DECLARE @active AS INT
				DECLARE @completed AS INT
				DECLARE @used AS INT

				EXEC sp_executesql @parserQuery, N'@sample int OUT, @active int OUT, @completed int OUT, @used int OUT', @sample=@sample OUT, @active=@active OUT, @completed=@completed OUT, @used=@used OUT

				INSERT INTO #TempQuotas([OfflineUserId], [Sample], [Active], [Completed], [Used]) VALUES (NULL, @sample, @active, @completed, @used)
			END ELSE BEGIN
				EXEC('INSERT INTO #TempQuotas([OfflineUserId], [Sample], [Active], [Completed], [Used]) ' + @parserQuery)
			END
		
			IF  EXISTS (SELECT TOP 1 * FROM #TempQuotas WHERE [OfflineUserId] IS NOT NULL)
			BEGIN
				UPDATE uq SET uq.[Frequence] = tq.[Completed] FROM [UserQuota] uq 
				INNER JOIN #TempQuotas tq ON uq.[UserId] = tq.[OfflineUserId] AND uq.[QuotaId] = @QuotaId
			END

			UPDATE [Quota] SET [OutOfSync] = 0, 
			[QtSample] = ISNULL((SELECT SUM([Sample]) FROM #TempQuotas), 0),
			[QtActive] = ISNULL((SELECT SUM([Active]) FROM #TempQuotas), 0),
			[QtFrequence] = ISNULL((SELECT SUM([Completed]) FROM #TempQuotas), 0),
			[QtUsed] = ISNULL((SELECT SUM([Used]) FROM #TempQuotas), 0),
			[QtParserQuery] =  @parserQuery 
			WHERE [QtQuotaId] = @QuotaId
		
			DROP TABLE #TempQuotas
		END
	END
GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_EvaluateCaseAssignments]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE [VSE_sp_EvaluateCaseAssignments]
GO
CREATE PROCEDURE [VSE_sp_EvaluateCaseAssignments]
	@ruleId          INT OUTPUT,
	@ResRespondent int
AS
BEGIN
  DECLARE surveyCursor CURSOR LOCAL FOR SELECT Id, OfflineUserId, SQLStatement, [Status] FROM [CaseAssignmentRules] Where [Active] = 1 ORDER BY [Priority]  Desc  
  DECLARE @sqlcmd nvarchar(max);  
  DECLARE @offlineUserId int;
  DECLARE @rId int;
  DECLARE @status tinyint;
  DECLARE @statement nvarchar(max);  
  DECLARE @result nvarchar;
  SET @result = null
  SET @ruleId = 0

     
  OPEN surveyCursor;
  FETCH NEXT FROM surveyCursor INTO @rId, @offlineUserId, @statement, @status
  WHILE @@FETCH_STATUS = 0  BEGIN
 SET @sqlcmd = REPLACE(@statement, '[RespondentId]', @ResRespondent)
 EXEC sp_executesql @sqlcmd, N'@result VARCHAR OUTPUT', @result OUTPUT;
    
 IF (@result is not null)
 BEGIN
  SET @ruleId = @rid
  BREAK;
 END

 FETCH NEXT FROM surveyCursor INTO @rId, @offlineUserId, @statement, @status;
  END

  CLOSE surveyCursor
  DEALLOCATE surveyCursor 
  

  IF (@result is not null)
  BEGIN
 UPDATE [Respondent] SET 
  [OfflineUserId] = @offlineUserId, 
  [Location] = @status, 
  [modifiedBy] = 0,
  [modified] = GETUTCDATE()
 WHERE [ResRespondent] = @ResRespondent
  END
END

GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentAppointment]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
DROP PROCEDURE [VSE_sp_UpdateRespondentAppointment]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentAppointment]
	-- Add the parameters for the stored procedure here
	@ResRespondent int,
	@AppointmentDate datetime
AS
BEGIN
	SET NOCOUNT ON;

	UPDATE [Respondent]  SET 
		[AppointmentDate] = @AppointmentDate, 
		[modifiedBy] = 0,
		[modified] = GETUTCDATE() 
	WHERE [ResRespondent] = @ResRespondent
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'A4S_SetRespondentsLocations') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'	PC'))
DROP PROCEDURE A4S_SetRespondentsLocations
GO
CREATE PROCEDURE [A4S_SetRespondentsLocations]
(
	@respondentIds AS [dbo].[RespondentList] READONLY,
	@location AS tinyint,
	@updateModified AS bit
)
AS
BEGIN
	UPDATE [Respondent] SET [Location] = @location, [Modified] = (CASE WHEN @updateModified = 1 THEN  GETUTCDATE() ELSE [Modified] END)
	WHERE [ResRespondent] IN (SELECT [Id] FROM @respondentIds)
END
GO
